/*
 *
 * Iskra SISTEMI (C) 2003  DM (davor.munda@kopica-sp.si)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Module: rtx_add.h - RTX Header with additional indirect prototypes.
 *
 * Version: 2.1.0 - 2003/05/06 : Basic version - DM
 *
 */


#ifndef __KERNEL__
/** Run RT thread in user space. **/
extern RTX_RESULT  runThread( rtx_task_handlePtr        *hndPtrP,       /* task handle pointer to pointer */
                              const rtx_priority         priority,      /* task priority */
                              const rtx_task_stacksize   stack,         /* stack size - bytes */
                              const rtx_task_mode        mode,          /* task mode */
                              const rtx_periodic_tick    nanoTick,      /* tick for periodic mode - nano sec */
                              rtx_periodic_tickPtr       tickPtr        /* tick space pointer */ );
/** Stop RT thread in user space. **/
extern RTX_RESULT  killThread( rtx_thread_handle  hnd /* thread handle */ );
/** Get free MBX channel in user space. **/
extern RTX_RESULT  getMBX( rtx_mbx_handlePtr     *mbxChPtrP, /* channel pointer to pointer */
                           const rtx_mbx_msgLen   msgLen,    /* message length - bytes */
                           const rtx_mbx_chMsgs   chMsgs     /* max no messages in the channel */ );
/** Create RTF FIFO handler in user space. **/
extern RTX_RESULT  rtfCreateHnd( const rtx_fifo_id              fifoId,      /* rtf fifo id - 0,...,63  for /dev/rtf0,...,/dev/rtf63 devices */
                                 rtx_fifo_handler_lxrt_thread   fifoHandler, /* LXRT thread - must be eternity loop and must poll fifo */
           						 rtx_thread_handlePtr           thread_hndPtr/* thread handle pointer */ );

#else
/** Get free MBX channel in kernel space. **/
extern RTX_RESULT  getMBX( rtx_mbx_handlePtr      mbxChPtr, /* channel pointer */
                           const rtx_mbx_msgLen   msgLen,   /* message length - bytes */
                           const rtx_mbx_chMsgs   chMsgs    /* max no messages in the channel */ );

/** Create RTF FIFO handler in kernel space. **/
extern RTX_RESULT  rtfCreateHnd( const rtx_fifo_id  fifoId,     /* rtf fifo id - 0,...,63  for /dev/rtf0,...,/dev/rtf63 devices */
#ifndef OS_WIN32
                                 rtx_fifo_handler   fifoHandler /* whenever Linux process (from user space) accesses fifo - R/W,
                                                                   handler routine is called - works only in kernel space */
#else
                                 rtx_fifo_handler_win32_thread   fifoHandler, /* Win32 thread - must be eternity loop and must poll fifo */
                                 rtx_thread_handlePtr            thread_hndPtr/* fake thread handle pointer */
#endif
                               );

#endif
